-- UserPreferences: User Preferences "Module"
-- Written by AJ Kelly of KKI Labs / Version 1.0

--[[

USAGE NOTE: READ THIS

Paths start in the StepMania root directory, so you will likely be using
a path like "Themes/themeName/Other".

How to decode what's needed when a path is asked for:

func(path,name)

path = The path to the file, like "Themes/themeName/Other/", but not including
the filename itself.

name = The name of the file to store the config in, without extension.
If you wish to change it, then edit the fileExt variable.

Be warned though, with this setup you can't have more than one file extension
without messing with the code.

]]

-- Link with EnvUtils2, if available.
local bUseEnvUtils2 = bUsingEnvUtils2;
-- File extension to use
local fileExt = ".cfg";

-- Local internal function to write envs. ___Not for themer use.___
local function WriteEnv(envName,envValue)
	if not bUseEnvUtils2 then return end;
	return setenv(envName,envValue);
end;

-- WritePref(path,name,value)
-- This is where the file writing magic happens.
-- Arg list:
--	path - path to filename you want to write.
--	name - filename you want to write, sans extension (filled in by fileExt).
--		   if bUseEnvUtils2 is true, this will also be the name of the Env
--		   that gets set to value.
--	value - what you want to set the value of name to.
--
-- Example usage:
--	WritePref("Themes/test/Other/","debug",true);
--	This will make a file called "debug.cfg" (with the defaults) containing
--	true.
function WritePref(path,name,value)
	-- get a file handle
	local f = RageFileUtil.CreateRageFile();
	local fullFilename = path..name..fileExt;
	
	if f:Open(fullFilename, 2) then
		f:Write(value);
		WriteEnv(name,value);
	else
		Trace( "[UserPreferences]: Could not write ".. fullFilename);
		SCREENMAN:SystemMessage("Writing of ".. fullFilename .." failed.\nLog.txt might have more info.");
		f:destroy();
		return false;
	end;
	
	f:destroy();
	return true;
end;

function ReadPref(path,name)
	local f = RageFileUtil.CreateRageFile();
	local fullFilename = path..name..fileExt;
	local option;
	
	if f:Open(fullFilename,1) then
		option = f:Read();
		WriteEnv(name,option);
		f:destroy();
		return option;
	else
		Trace( "[UserPreferences]: Could not read "..fullFilename);
		SCREENMAN:SystemMessage("Reading of ".. fullFilename .." failed.\nCheck Log.txt for more info.");
		f:destroy();
		return false;
	end;
end;

--[[
Copyright  2008 AJ Kelly/KKI Labs
All rights reserved.

This code is licensed under AJ's Generic Use of Code License.
An up to date copy can be found at the following address:
http://kki.ajworld.net/wiki/AJ%27s_Generic_Use_of_Code_License
However, keep in mind that the code in this file is bound to the exact
specifications found in this file.
That is to say, changes are not retroactive.

When using this code in your theme, you agree to the following points:

1. Redistributions of anything that uses this code must retain the above
copyright notice and this list of conditions.

2. Not hide/require registration for any theme that uses the code from the
public IF there is a public release. (This means private themes and themes for
commercial games can use the code without worry.)

3. Not compile the code down to bytecode (if the code is Lua) in a public
theme. (Yes, it can be reversed, but regardless, this hinders openness and
sharing.)

4. This code is a unique/nontrivial creation, therefore, credit should be
given to the creator of the code if used in another theme.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
]]